<?php
include('include/connection.php'); 
session_start();

// Check if user is authenticated
if (!isset($_SESSION['uID']) || empty($_SESSION['uID'])) {
    header("location: index.php");
    exit;
}

// Function to get data points from queries
function getDataPoints($link, $query) {
    $stmt = $link->prepare($query);
    $stmt->execute();
    $result = $stmt->get_result();
    $dataPoints = [];
    while ($row = $result->fetch_assoc()) {
        $dataPoints[] = ['label' => $row[array_keys($row)[0]], 'y' => (int)$row[array_keys($row)[1]]];
    }
    $stmt->close();
    return $dataPoints;
}

// Queries for data points
$dataPoints6 = getDataPoints($link, "SELECT provider, count(provider) as Total FROM simcard_tbl GROUP BY provider");
$dataPoints5 = getDataPoints($link, "SELECT status, COUNT(status) AS Status FROM simcard_tbl GROUP BY status");
$dataPoints7 = getDataPoints($link, "SELECT store, COUNT(store) AS Store FROM simcard_tbl GROUP BY store");
$dataPoints8 = getDataPoints($link, "SELECT status, COUNT(status) AS Status FROM device_tbl GROUP BY status");
$dataPoints9 = getDataPoints($link, "SELECT MONTH(installDate) AS Month, SUM(cost) AS Amount FROM fleet_view GROUP BY MONTH(installDate)");
$dataPoints10 = getDataPoints($link, "SELECT companyName, SUM(cost) AS Amount FROM fleet_view GROUP BY companyName");

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <title>INTERNAL DATA</title>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/css/dashboard.css" rel="stylesheet">
    
    <!-- jQuery and CanvasJS -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://canvasjs.com/assets/script/canvasjs.min.js"></script>
    
    <script>
        // Function to create charts
        function createChart(container, title, dataPoints, type = "column") {
            return new CanvasJS.Chart(container, {
                animationEnabled: true,
                exportEnabled: true,
                theme: "light2",
                title: { text: title },
                data: [{ type, yValueFormatString: "###", indexLabel: "{y}", dataPoints }]
            });
        }
        
        // Render charts on page load
        $(document).ready(function() {
            createChart("chartContainer6", "Provider", <?php echo json_encode($dataPoints6, JSON_NUMERIC_CHECK); ?>).render();
            createChart("chartContainer5", "Status", <?php echo json_encode($dataPoints5, JSON_NUMERIC_CHECK); ?>, "bar").render();
            createChart("chartContainer7", "Store", <?php echo json_encode($dataPoints7, JSON_NUMERIC_CHECK); ?>, "pie").render();
            createChart("chartContainer8", "Device", <?php echo json_encode($dataPoints8, JSON_NUMERIC_CHECK); ?>, "pie").render();
            createChart("chartContainer9", "Fleet Amount Per Month", <?php echo json_encode($dataPoints9, JSON_NUMERIC_CHECK); ?>, "spline").render();
            createChart("chartContainer10", "Fleet Amount Per Company", <?php echo json_encode($dataPoints10, JSON_NUMERIC_CHECK); ?>).render();
        });
    </script>
</head>
<body>
<div class="container-fluid">
    <!-- Navigation and Header -->
    <div class="row">
        <div class="col-sm-12 py-4 text-center">
            <div class="alert alert-success">
                <h2><span class="badge bg-secondary">INCOMING DATA</span></h2>
                DASHBOARD
            </div>
            <!-- Navigation Buttons -->
            <a href="devices.php" class="btn btn-info">DEVICES</a>
            <a href="simcards.php" class="btn btn-info">SIMCARDS</a>
            <a href="fleet_view.php" class="btn btn-info">FLEET RECORDS</a>
            <a href="hosting_view.php" class="btn btn-info">HOSTINGS</a>
            <a href="clients.php" class="btn btn-info">CLIENTS</a>
            <a href="db.php" target="_blank" class="btn btn-info">DATABASE</a>
            <a href="logout.php" class="btn btn-info">LOGOUT</a>
        </div>
    </div>

    <!-- Statistics and Charts -->
    <div class="container">
        <!-- Summary Stats -->
        <div class="row text-center">
            <div class="col-md-3"><h1 style="color:#668080;">Clients</h1><p style="font-size:70px;color:#668080;"><b><?php echo $row1[0]; ?></b></p></div>
            <div class="col-md-3"><h1 style="color:#2C8975;">SimCards</h1><p style="font-size:70px;color:#668080;"><b><?php echo $row2[0]; ?></b></p></div>
            <div class="col-md-3"><h1 style="color:#796680;">Devices</h1><p style="font-size:70px;color:#668080;"><b><?php echo $row3[0]; ?></b></p></div>
            <div class="col-md-3"><h1 style="color:#668080;">Fleets</h1><p style="font-size:70px;color:#668080;"><b><?php echo $row4[0]; ?></b></p></div>
        </div>
        
        <!-- Chart Containers -->
        <div class="row">
            <div class="col-md-4"><div id="chartContainer5" style="height: 370px; width: 100%;"></div></div>
            <div class="col-md-4"><div id="chartContainer7" style="height: 370px; width: 100%;"></div></div>
            <div class="col-md-4"><div id="chartContainer6" style="height: 370px; width: 100%;"></div></div>
        </div>
        
        <div class="row">
            <div class="col-md-4"><div id="chartContainer8" style="height: 370px; width: 100%;"></div></div>
            <div class="col-md-8"><div id="chartContainer9" style="height: 370px; width: 100%;"></div></div>
        </div>
        
        <div class="row">
            <div class="col-md-12"><div id="chartContainer10" style="height: 370px; width: 100%;"></div></div>
        </div>
    </div>
</div>

<!-- Bootstrap JavaScript Bundle with Popper -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
