<?php
include_once 'include/connection.php';
session_start();

// Check if user is logged in
if (empty($_SESSION['uID'])) {
    header("location: index.php");
    exit;
}

$error = $msg = '';

// Handle Add Device Form Submission
if (isset($_POST['submit'])) {
    $dID = mysqli_real_escape_string($link, $_POST['dID']);
    $deviceName = mysqli_real_escape_string($link, $_POST['deviceName']);

    // Check if Device ID already exists
    $checkQuery = mysqli_query($link, "SELECT * FROM device_tbl WHERE dID='$dID'");
    if (mysqli_num_rows($checkQuery) > 0) {
        $error = "Device ID already exists.";
    } else {
        // Insert Device
        $query = "INSERT INTO device_tbl (dID, deviceName, status) VALUES ('$dID', '$deviceName', 'Active')";
        if (mysqli_query($link, $query)) {
            $msg = "Device added successfully.";
        } else {
            $error = "Error: " . mysqli_error($link);
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Device Records</title>
    
    <!-- Bootstrap CSS and DataTables CSS -->
    <link href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.datatables.net/1.13.1/css/dataTables.bootstrap4.min.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-4">
        <div class="text-center mb-4">
            <h2>CREATE Devices Dashboard</h2>
        </div>

        <!-- Display Messages -->
        <?php if ($error) echo "<div class='alert alert-danger'>$error</div>"; ?>
        <?php if ($msg) echo "<div class='alert alert-success'>$msg</div>"; ?>

        <!-- Navigation Buttons -->
        <div class="d-flex justify-content-center mb-3">
            <a href="adminDashboard.php" class="btn btn-primary mx-2">HOME</a>
            <button class="btn btn-info mx-2" data-toggle="modal" data-target="#addDeviceModal">ADD DEVICES</button>
            <a href="clients.php" class="btn btn-info mx-2">CLIENTS</a>
        </div>

        <!-- Add Device Modal -->
        <div class="modal fade" id="addDeviceModal" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header alert-success">
                        <h5 class="modal-title">Add Device</h5>
                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                    </div>
                    <form method="POST" action="">
                        <div class="modal-body">
                            <div class="form-group">
                                <label for="dID">Device ID</label>
                                <input type="text" name="dID" class="form-control" required>
                            </div>
                            <div class="form-group">
                                <label for="deviceName">Device Name</label>
                                <input type="text" name="deviceName" class="form-control">
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" name="submit" class="btn btn-info">Add Device</button>
                            <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- Device Table -->
        <table id="deviceTable" class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>Device ID</th>
                    <th>Device Name</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $result = mysqli_query($link, "SELECT * FROM device_tbl");
                while ($row = mysqli_fetch_assoc($result)) {
                    echo "<tr>
                        <td>{$row['dID']}</td>
                        <td>{$row['deviceName']}</td>
                        <td>{$row['status']}</td>
                    </tr>";
                }
                ?>
            </tbody>
        </table>
    </div>

    <!-- JavaScript Libraries -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.1/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.1/js/dataTables.bootstrap4.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>

    <script>
        $(document).ready(function() {
            $('#deviceTable').DataTable();
        });
    </script>
</body>
</html>
