<?php 
    include("include/connection.php"); 

    session_start();
    $uID = $_SESSION['uID'];
    if(empty($uID)) {
        header("location: index.php");
    }
?>

<html>
<head>
    <title>Fleet record</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.10.21/css/dataTables.bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.6.2/css/buttons.bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">

    <script language="javascript" type="text/javascript">
        var popUpWin = 0;
        function popUpWindow(URLStr, left, top, width, height) {
            if (popUpWin) {
                if (!popUpWin.closed) popUpWin.close();
            }
            popUpWin = open(URLStr, 'popUpWin', 'toolbar=no,location=yes,directories=no,status=no,menubar=no,scrollbars=yes,resizable=no,copyhistory=yes,width=' + 600 + ',height=' + 600 + ',left=' + left + ', top=' + top + ',screenX=' + left + ',screenY=' + top + '');
        }
    </script>
</head>
<body>
<div class="container-fluid"> 
    <div class="row">
        <div class="col-sm-12">    
            <center>
                <div class="alert alert-success" role="alert">
                    <h2><span class="badge badge-secondary">INTERNAL DATA | FLEET VIEW</span></h2>
                    DASHBOARD
                </div>
            </center>
            <a href="adminDashboard.php"> <button class="btn btn-primary" type="button">HOME</button></a> 
            <a href="fleet_add.php"> <button class="btn btn-info" type="button">ADD FLEET</button></a>    
            <a href="clients.php"> <button type="submit" class="btn btn-info"><b> CLIENTS </b></button> </a>
            <a href="simcards.php"> <button type="submit" class="btn btn-info"><b> SIMCARDS </b></button></a>
            <a href="hosting_view.php"> <button type="submit" class="btn btn-info"><b> HOSTINGS </b></button></a>
            
            <!-- Modal for fleet -->
            <div class="form-group">
                <div class="modal fade" id="approve_modal" aria-hidden="true">
                    <center>
                        <form method="POST" action="">
                            <div class="modal-header alert-success">
                                <h3>Update Fleet </h3>
                            </div>
                            <div class="modal-body">    
                                <table class="datatable-1 table table-striped">
                                    <tr><td>No </td><td><input type="text" id="No" name="No" readonly/></td></tr>
                                    <tr><td>dID </td><td><input type="text" id="d" name="dID" readonly/></td></tr>
                                    <tr><td>simID </td><td><input type="text" id="s" name="simID" readonly/></td></tr>
                                    <tr><td> plateNo</td><td><input type="text" id="p" name="plateNo" placeholder="Plate No" required/></td></tr>
                                    <tr><td>Cost </td><td><input type="number" id="co" name="cost" placeholder="Cost" required/></td></tr>
                                    <tr><td>Comment </td><td><input type="text" id="com" name="comment" placeholder="Comment" /></td></tr>
                                    <tr><td><input type="submit" class="btn btn-info" name="submit" value="Update"/></td></tr>

                                    <?php
                                    if(isset($_POST['submit'])) {
                                        $No = $_POST['No'];
                                        $plateNo = $_POST['plateNo'];
                                        $cost = $_POST['cost'];
                                        $comment = $_POST['comment'];

                                        if($plateNo != '' && $cost != '') {
                                            $query = "UPDATE fleet_tbl SET plateNo='$plateNo', cost='$cost', comment='$comment' where No='$No'";
                                            $result = mysqli_query($link, $query);
                                            if($result) {
                                                $_SESSION['status'] = "<div class='alert-success'><p> Data has been added successfully. </p> </div>";
                                            }
                                        } else {
                                            echo "please fill all required detail";
                                        }
                                    }
                                    ?>
                                </table> 
                            </div>
                            <div style="clear:both;"></div>
                            <div class="modal-footer">
                                <button class="btn btn-danger" type="button" data-dismiss="modal"><span class="fa fa-times"></span> Close</button>
                            </div>
                        </form>
                    </center>
                </div>

                <!-- Modal for simcard -->
                <div class="form-group">
                    <div class="modal fade" id="simcard_modal" aria-hidden="true">
                        <center>
                            <form method="POST" action="">
                                <div class="modal-header alert-success">
                                    <h3>Update simcard Status </h3>
                                </div>
                                <div class="modal-body">    
                                    <table class="datatable-1 table table-striped">
                                        <tr><td>No </td><td><input type="text" id="No1" name="No" readonly/></td></tr>
                                        <tr><td>ClientID </td><td><input type="text" id="c1" name="clientID" readonly/></td></tr>
                                        <tr><td>dID </td><td><input type="text" id="d1" name="dID" readonly/></td></tr>
                                        <tr><td>simID </td><td><input type="text" id="s1" name="simcard" readonly/></td></tr>
                                        <tr><td>Status </td><td>
                                            <select name="status" id="p1">
                                                <option value="Active"> Active </option>                             
                                                <option value="Inactive"> Inactive </option> 
                                                <option value="Suspended"> Suspended </option> 
                                            </select>
                                        </td></tr> 
                                        <tr><td><input type="submit" class="btn btn-info" name="submit" value="Update"/></td></tr>

                                        <?php
                                        if(isset($_POST['submit'])) {
                                            $simcard = $_POST['simcard'];
                                            $status = $_POST['status'];

                                            if($status != '') {
                                                $query45 = "UPDATE simcard_tbl SET status='$status' where simID='$simcard'";
                                                $result45 = mysqli_query($link, $query45);
                                                if($result45) {
                                                    $_SESSION['status'] = "<div class='alert-success'><p> Data has been added successfully. </p> </div>";
                                                }
                                            } else {
                                                echo "please fill all required detail";
                                            }
                                        }
                                        ?>
                                    </table> 
                                </div>
                                <div style="clear:both;"></div>
                                <div class="modal-footer">
                                    <button class="btn btn-danger" type="button" data-dismiss="modal"><span class="fa fa-times"></span> Close</button>
                                </div>
                            </form>
                        </center>
                    </div>
                </div>
            </div>

            <table id="example" class="table table-striped table-bordered" style="width:100%">
                <thead>
                    <tr>
                        <th>No</th> 
                        <th>dID</th>
                        <th>simID</th>
		                <th>Prvd</th>
                        <th>simStatus</th>
                        <th>CompanyName</th> 
                        <th>Client Name</th>
                        <th>Plate No</th>
                        <th>Cost</th>
                        <th>InstallDate</th>
                        <th>Comment</th>
                        <th scope="col">Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $result = mysqli_query($link,"SELECT * FROM fleet_view ORDER BY No ASC limit 1000");
                    while($row = mysqli_fetch_array($result)) {
                    ?>
                    <tr>
                        <td><?php echo $row['No']; ?></td>
                        <td><?php echo $row['dID']; ?></td>
                        <td><?php echo $row['simID']; ?></td>
                        <td><?php echo $row['provider']; ?></td>
                        <td><?php echo $row['status']; ?></td>
                        <td><?php echo $row['companyName']; ?></td>
                        <td><?php echo $row['clientName']; ?></td>
                        <td><?php echo $row['plateNo'];?></td>
                        <td><?php echo $row['cost'];?></td>
                        <td><?php echo $row['installDate'];?></td>
                        <td><?php echo $row['comment'];?></td>
                        <td>
                            <button class="btn btn-info simcard" data-toggle="modal" data-target="#simcard_modal" type="button" data-id="<?php echo $row['simID']; ?>" data-d="<?php echo $row['dID']; ?>" data-no="<?php echo $row['No']; ?>" data-c="<?php echo $row['clientID']; ?>">
                                <i class="fas fa-phone"></i>
                            </button>
                            <button class="btn btn-primary approve" data-toggle="modal" data-target="#approve_modal" type="button" data-no="<?php echo $row['No']; ?>" data-plate="<?php echo $row['plateNo']; ?>" data-cost="<?php echo $row['cost']; ?>" data-com="<?php echo $row['comment']; ?>">
                                <i class="fas fa-edit"></i>
                            </button>
                            <a href="fleet_delete.php?No=<?php echo $row['No']; ?>">
                                <button class="btn btn-danger" type="button">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </a>
                        </td>
                    </tr>
                    <?php 
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>
<script src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.10.21/js/dataTables.bootstrap.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.6.2/js/dataTables.buttons.min.js"></script>
<script>
$(document).ready(function() {
    $('#example').DataTable();
    
    // Populating modals with data
    $('#approve_modal').on('show.bs.modal', function (event) {
        var button = $(event.relatedTarget);
        var modal = $(this);
        modal.find('#No').val(button.data('no'));
        modal.find('#p').val(button.data('plate'));
        modal.find('#co').val(button.data('cost'));
        modal.find('#com').val(button.data('com'));
    });
    
    $('#simcard_modal').on('show.bs.modal', function (event) {
        var button = $(event.relatedTarget);
        var modal = $(this);
        modal.find('#No1').val(button.data('no'));
        modal.find('#c1').val(button.data('c'));
        modal.find('#d1').val(button.data('d'));
        modal.find('#s1').val(button.data('id'));
    });
});
</script>
</body>
</html>
